package com.ejie.p06b.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.ejie.p06b.general.P06BConstantes;

public class R76bParameters {
	
	//private static final String FICH_CONFIG = "/r76b/r76b.properties";
	//private static final String FICH_CONFIG = "/config/wl11_intra_apps_dpto/r76b/r76b.properties";
	
	private Properties par = null;

	/**
	 * Mtoque que obtiene los parmetros asociados a la aplicacin de su
	 * fichero de configuracin asociado
	 * 
	 * @return Devuelve un objeto de tipo Properties con los parmetros
	 *         asociados a la aplicacin
	 * 
	 * @throws IOException
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public Properties getParametros() throws IOException {

		if (this.par == null) {
			this.par = new Properties();
			//InputStream in = this.getClass().getResourceAsStream(
			//		R76bParameters.FICH_CONFIG);
			//InputStream in = this.getClass().getResourceAsStream(r76bCPaginas.DEFAULT);
			FileInputStream in=new FileInputStream(new File(P06BConstantes.P06B_PROPERTIES_DEFAULT));
			
			this.par.load(in);
			in.close();
		}
		return (this.par);

	}

	/**
	 * Mtoque que obtiene los parmetros asociados a la aplicacin de su
	 * fichero de configuracin asociado
	 * 
	 * @param path
	 *            : Objeto de tipo String con el path donde se encuentra el
	 *            fichero de configuracin de la aplicacin
	 * 
	 * @return Devuelve un objeto de tipo Properties con los parmetros
	 *         asociados a la aplicacin
	 * 
	 * @throws IOException
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public Properties getParametros(String path) throws IOException {
		Properties par = null;

		par = new Properties();
		InputStream in = this.getClass().getResourceAsStream(path);
		par.load(in);
		in.close();

		return (par);
	}

}
